-- HAL Copycat Risk Factor Quiz - Complete Seed Data
-- Run this AFTER the main database.sql to populate the quiz

-- Insert the quiz
INSERT INTO quizzes (uuid, slug, title, description, published, lead_capture_position, design) VALUES (
  UUID(),
  'copycat-risk-factor',
  'Is Your Business a Copycat Magnet?',
  'Most entrepreneurs are shocked by their actual risk level.',
  1,
  'on_landing',
  '{
    "primaryColor": "#FF6B8A",
    "secondaryColor": "#1E1B4B",
    "landingHeadline": "Take The FREE \"Biz\" Risk Quiz",
    "landingSubheadline": "Find out in 2 minutes. Discover your Copycat Risk Factor—and see if weak contracts or missing protections are leaving you exposed.",
    "formHeadline": "Enter Your Details to Begin!",
    "ctaText": "Get My FREE Personalized Results",
    "showRiskLevels": true,
    "benefitsHeadline": "What You''ll Discover in 2 Minutes:",
    "benefits": [
      "Your personalized vulnerability score (with detailed breakdown)",
      "Specific gaps in your current protection that need immediate attention",
      "Custom action plan with steps you can implement today",
      "Industry insight - how you stack up against competitors",
      "Red flag warning signs to watch for in your business",
      "Professional recommendations tailored to your risk level"
    ],
    "bonusText": "Get your detailed Copycat Risk Factor Report delivered instantly to your email.",
    "showRiskSection": true,
    "riskHeadline": "What''s Really at Risk?",
    "riskItems": [
      "Your signature frameworks worth $25,000+ in development time",
      "Your client lists and proprietary relationship insights",
      "Your proven processes that took years to perfect",
      "Your competitive advantage in the marketplace",
      "Your business reputation and client trust"
    ],
    "riskCta": "Most entrepreneurs have NO IDEA how exposed they really are.",
    "bottomCtaText": "Get Your FREE Personalized Report"
  }'
);

SET @quiz_id = LAST_INSERT_ID();

-- Lead capture fields
INSERT INTO lead_fields (quiz_id, field_name, field_label, field_type, required, placeholder, order_index) VALUES
(@quiz_id, 'name', 'First Name', 'text', 1, 'First name *', 1),
(@quiz_id, 'email', 'Email', 'email', 1, 'Email *', 2);

-- ===========================================
-- QUESTIONS
-- ===========================================

-- Q1: Tell me about your business
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index, settings) VALUES
(@quiz_id, UUID(), 'Tell me about your business! (Select all that apply)', 'multiple', 1, '{"allowMultiple": true}');
SET @q1_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q1_id, UUID(), 'Online content (courses, digital products, ebooks)', 2, 1),
(@q1_id, UUID(), 'Freelancer, independent contractor, professional services', 1, 2),
(@q1_id, UUID(), 'Product sold via custom platform', 1, 3),
(@q1_id, UUID(), 'Consulting, coaching, speaking (virtual and/or in person)', 2, 4),
(@q1_id, UUID(), 'Physical or digital product via third party platform (Etsy, Shopify, FBA)', 0, 5),
(@q1_id, UUID(), 'Back office services (VA, bookkeeping, social media manager)', 0, 6);

-- Q2: Tell me about your clients
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index, settings) VALUES
(@quiz_id, UUID(), 'Tell me about your clients (Select all that apply)', 'multiple', 2, '{"allowMultiple": true}');
SET @q2_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q2_id, UUID(), 'My clients treat me like a servant instead of a valued professional', 2, 1),
(@q2_id, UUID(), 'My clients miss meetings, no-show, or reschedule on short notice', 2, 2),
(@q2_id, UUID(), 'My client disrespects my team or undermines me in group calls', 2, 3),
(@q2_id, UUID(), 'My clients are awesome and I don''t have client issues', 0, 4),
(@q2_id, UUID(), 'My clients don''t pay on time and I have to chase money', 2, 5),
(@q2_id, UUID(), 'My clients keep changing their minds and scope', 2, 6),
(@q2_id, UUID(), 'My client tries to micromanage me', 0, 7);

-- Q3: Tell me about your clients' attitude
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index, settings) VALUES
(@quiz_id, UUID(), 'Tell me about your clients'' attitude! (Select all that apply)', 'multiple', 3, '{"allowMultiple": true}');
SET @q3_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q3_id, UUID(), 'My clients are needy, always looking for more support at all hours', 2, 1),
(@q3_id, UUID(), 'My clients are argumentative, they don''t trust the process', 2, 2),
(@q3_id, UUID(), 'My clients have unrealistic expectations for how long or how much effort it will take', 2, 3),
(@q3_id, UUID(), 'My clients are cranky, I get a lot of demands for refunds or rework', 2, 4),
(@q3_id, UUID(), 'My clients are flip floppers, always changing their minds and scope', 2, 5),
(@q3_id, UUID(), 'My clients go rogue and self-sabotage, or worse, let me get surprised', 2, 6),
(@q3_id, UUID(), 'My clients are awesome and I don''t have client issues', 0, 7);

-- Q4: How often do you give in
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'How often do you ''give in'' just to get a client or keep the peace?', 'single', 4);
SET @q4_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q4_id, UUID(), 'Not once, ever', 0, 1),
(@q4_id, UUID(), 'It''s happened, but not often', 1, 2),
(@q4_id, UUID(), 'It''s common enough that we have a process but I try not to', 2, 3),
(@q4_id, UUID(), 'I''m constantly renegotiating services, scope, and price with my current clients', 3, 4),
(@q4_id, UUID(), 'My clients are out of control and it''s ruining my business (and my life)', 4, 5);

-- Q5: Scope creep
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index, settings) VALUES
(@quiz_id, UUID(), 'What''s the most common way ''scope creep'' shows up in your business? (Select all that apply)', 'multiple', 5, '{"allowMultiple": true}');
SET @q5_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q5_id, UUID(), 'I end up paying for essential subscriptions, apps, or tools when my client won''t', 2, 1),
(@q5_id, UUID(), 'I discount my price/fee', 2, 2),
(@q5_id, UUID(), 'I finally get so fed up that I do extra work just to finally get a project done', 2, 3),
(@q5_id, UUID(), 'I spend hours having the same conversation to manage client expectations', 2, 4),
(@q5_id, UUID(), 'I redo work (for free) when my client changes their mind', 2, 5),
(@q5_id, UUID(), 'I always stay in scope', 0, 6);

-- Q6: Business boundaries
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index, settings) VALUES
(@quiz_id, UUID(), 'Tell me about your business boundaries!', 'multiple', 6, '{"allowMultiple": true}');
SET @q6_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q6_id, UUID(), 'I''m available to my clients 24/7', 3, 1),
(@q6_id, UUID(), 'I feel comfortable communicating with clients only during my work hours', 0, 2),
(@q6_id, UUID(), 'I can''t afford to disappoint any client', 2, 3),
(@q6_id, UUID(), 'I set my limits without hurting the client relationship', 0, 4),
(@q6_id, UUID(), 'I know where I''d like to set limits but don''t always feel like I can', 2, 5);

-- Q7: Do you use VAs
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'Do you use Virtual Assistants (VAs) in your business?', 'single', 7);
SET @q7_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q7_id, UUID(), 'Yes', 5, 1),
(@q7_id, UUID(), 'No', 2, 2);

-- Q8: How do you use VAs
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index, settings) VALUES
(@quiz_id, UUID(), 'How do you use Virtual Assistants (VAs)?', 'multiple', 8, '{"allowMultiple": true, "showIf": "uses_va"}');
SET @q8_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q8_id, UUID(), 'For social media (content creation, posting, group admin)', 3, 1),
(@q8_id, UUID(), 'For marketing (ad copy, email list management)', 3, 2),
(@q8_id, UUID(), 'For branding: graphics, web design/hosting, logo', 3, 3),
(@q8_id, UUID(), 'For customer service or client-facing service delivery', 5, 4);

-- Q9: How did you hire your VA
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'Did you hire your VA directly or through a service?', 'single', 9);
SET @q9_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q9_id, UUID(), 'Personal contact – I know them and their work personally', 1, 1),
(@q9_id, UUID(), 'Directly – I hired someone through my personal referral network', 2, 2),
(@q9_id, UUID(), 'Indirectly – through a service platform like Fiverr or Upwork', 7, 3),
(@q9_id, UUID(), 'Indirectly – I hired a service that assigned me to someone', 5, 4);

-- Q10: Where is your VA located
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'Do you know where your VA is physically located?', 'single', 10);
SET @q10_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q10_id, UUID(), 'My VA is located in the same country as my business', 1, 1),
(@q10_id, UUID(), 'My VA is located in a different country', 3, 2),
(@q10_id, UUID(), 'I don''t know', 5, 3);

-- Q11: Do you use contractors
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'Do you use Independent Contractors / Service Providers?', 'single', 11);
SET @q11_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q11_id, UUID(), 'Yes', 5, 1),
(@q11_id, UUID(), 'No', 2, 2);

-- Q12: How do you use contractors
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index, settings) VALUES
(@quiz_id, UUID(), 'How do you use Independent Contractors / Service Providers?', 'multiple', 12, '{"allowMultiple": true}');
SET @q12_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q12_id, UUID(), 'Enrollment coach or sales rep, lead gen or call screener', 2, 1),
(@q12_id, UUID(), 'Customer service (they communicate directly with my customers)', 2, 2),
(@q12_id, UUID(), 'Building or maintaining my tech', 2, 3),
(@q12_id, UUID(), 'Marketing agency, branding, logo', 2, 4),
(@q12_id, UUID(), 'Delivering all or part of my course or services', 2, 5),
(@q12_id, UUID(), 'Back office (invoices, contract admin)', 2, 6);

-- Q13: How did you hire contractors
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'Did you hire your Contractor directly or through a service?', 'single', 13);
SET @q13_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q13_id, UUID(), 'Personal contact – I know them and their work personally', 1, 1),
(@q13_id, UUID(), 'Directly – I hired someone through my personal referral network', 2, 2),
(@q13_id, UUID(), 'Indirectly – through a service platform like Fiverr or Upwork', 5, 3),
(@q13_id, UUID(), 'Indirectly – I hired a service that assigned me to someone', 5, 4);

-- Q14: How did you create your product
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'How did you create your primary product, lead magnet, book, or course?', 'single', 14);
SET @q14_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q14_id, UUID(), 'It was all me', 1, 1),
(@q14_id, UUID(), 'I hired someone and paid more than $100', 2, 2),
(@q14_id, UUID(), 'I used a template or used AI to brainstorm', 4, 3),
(@q14_id, UUID(), 'I hired someone and paid less than $100', 5, 4),
(@q14_id, UUID(), 'I used AI tools to create the whole thing', 5, 5),
(@q14_id, UUID(), 'I "borrowed" someone else''s course/book/product', 10, 6);

-- Q15: Do you use others' content
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'Do you routinely use content, designs, assessments, elements or code created by someone else?', 'single', 15);
SET @q15_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q15_id, UUID(), 'No, it''s all me', 0, 1),
(@q15_id, UUID(), 'Yes, but I know it''s public domain or open source', 2, 2),
(@q15_id, UUID(), 'Yes, I use specialized assessments or materials with permission', 2, 3),
(@q15_id, UUID(), 'Yes, but I hired someone to create it for me', 3, 4),
(@q15_id, UUID(), 'Yes, but I found it for free on the internet so it was OK, right?', 5, 5),
(@q15_id, UUID(), 'I''m not sure', 2, 6);

-- Q16-21: AI Questions
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'AI wrote my book / course, ad copy, email copy, social media posts', 'single', 16);
SET @q16_id = LAST_INSERT_ID();
INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q16_id, UUID(), 'Yes', 10, 1),
(@q16_id, UUID(), 'No', 1, 2);

INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'AI repurposes my content into other forms', 'single', 17);
SET @q17_id = LAST_INSERT_ID();
INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q17_id, UUID(), 'Yes', 10, 1),
(@q17_id, UUID(), 'No', 1, 2);

INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'AI created my digital product / download', 'single', 18);
SET @q18_id = LAST_INSERT_ID();
INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q18_id, UUID(), 'Yes', 10, 1),
(@q18_id, UUID(), 'No', 1, 2);

INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'AI created the graphics for my print-on-demand or similar product', 'single', 19);
SET @q19_id = LAST_INSERT_ID();
INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q19_id, UUID(), 'Yes', 5, 1),
(@q19_id, UUID(), 'No', 0, 2);

INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'AI keeps track of my notes, calendar, to do list', 'single', 20);
SET @q20_id = LAST_INSERT_ID();
INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q20_id, UUID(), 'Yes', 5, 1),
(@q20_id, UUID(), 'No', 2, 2);

INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'AI chats with my customers', 'single', 21);
SET @q21_id = LAST_INSERT_ID();
INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q21_id, UUID(), 'Yes', 5, 1),
(@q21_id, UUID(), 'No', 2, 2);

-- Q22: Non-solicitation clause
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'Do you have a Non-Solicitation Clause in your Contract with VA/Contractors?', 'single', 22);
SET @q22_id = LAST_INSERT_ID();
INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q22_id, UUID(), 'Yes', 1, 1),
(@q22_id, UUID(), 'No', 5, 2),
(@q22_id, UUID(), 'What''s a non-solicitation clause?', 5, 3);

-- Q23: Copyright/trademark
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'Have you ever applied for a copyright or trademark registration?', 'single', 23);
SET @q23_id = LAST_INSERT_ID();
INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q23_id, UUID(), 'I have registered a trademark or copyright for my core content', 0, 1),
(@q23_id, UUID(), 'I haven''t registered it yet', 2, 2),
(@q23_id, UUID(), 'Register what with who?', 5, 3);

-- ===========================================
-- RESULT PAGES
-- ===========================================

-- LOW RISK Result (0-20 points)
INSERT INTO pages (quiz_id, uuid, slug, title, type, blocks, is_default, mailchimp_tag, kit_tag, settings) VALUES
(@quiz_id, UUID(), 'low-risk', 'Low Copycat Risk Factor', 'result', 
'[
  {"type": "heading", "content": "🟢 Congratulations!"},
  {"type": "text", "content": "Hey {{first_name}}... Congratulations on having a Low Copycat Risk Factor! Just because you have low risk does not mean there is no risk. Now let''s look at ways to keep managing your Copycat Risk Factor."},
  {"type": "text", "content": "Check out the report I prepared for you. I emailed it to: {{email}}."},
  {"type": "button", "text": "Download Your Copycat Risk Factor Report", "url": "https://happyatlaw.com/report-low"},
  {"type": "heading", "content": "What Your LOW Risk Score Means:"},
  {"type": "text", "content": "You''ve built solid foundations, but there are still some sophisticated vulnerabilities that could be exploited by VAs and contractors, industry changes, competitors, and AI tools."},
  {"type": "heading", "content": "IMMEDIATE ACTION STEPS:"},
  {"type": "text", "content": "Step 1: Conduct an annual contract review with fresh eyes\\nStep 2: Update protections for any new business models or services\\nStep 3: Review team access levels as your business has grown"},
  {"type": "button", "text": "Protect My Business for $7 - Start Day 1 Now", "url": "https://happyatlaw.com/7-day-assessment"}
]',
0, 'copycat-low-risk', 'copycat-low-risk',
'{"minScore": 0, "maxScore": 20}');

-- MEDIUM RISK Result (21-49 points)
INSERT INTO pages (quiz_id, uuid, slug, title, type, blocks, is_default, mailchimp_tag, kit_tag, settings) VALUES
(@quiz_id, UUID(), 'medium-risk', 'Medium Copycat Risk Factor', 'result',
'[
  {"type": "heading", "content": "🟡 Medium Risk Detected"},
  {"type": "text", "content": "Hey {{first_name}}... Your answers indicated a Copycat Risk Factor of: MEDIUM. Here''s what that means: You''re not in immediate danger, but you have several vulnerabilities that could become serious problems if left unaddressed."},
  {"type": "text", "content": "Think of it like having a few small leaks in your roof - manageable now, but they''ll cause major damage if ignored."},
  {"type": "button", "text": "Download Your Copycat Risk Factor Report", "url": "https://happyatlaw.com/report-medium"},
  {"type": "heading", "content": "What Your MEDIUM Risk Score Means:"},
  {"type": "text", "content": "Your business has some protection in place, but there are still gaps that make it possible for team members to walk away with your proprietary processes, competitors to reverse-engineer your methods, and contract loopholes to expose you during disputes."},
  {"type": "heading", "content": "IMMEDIATE ACTION STEPS:"},
  {"type": "text", "content": "Step 1: Review all current team member access to sensitive materials\\nStep 2: Update your standard contract template with stronger IP clauses\\nStep 3: Create a confidential information inventory"},
  {"type": "button", "text": "Protect My Business for $7 - Start Day 1 Now", "url": "https://happyatlaw.com/7-day-assessment"}
]',
0, 'copycat-medium-risk', 'copycat-medium-risk',
'{"minScore": 21, "maxScore": 49}');

-- HIGH RISK Result (50+ points)
INSERT INTO pages (quiz_id, uuid, slug, title, type, blocks, is_default, mailchimp_tag, kit_tag, settings) VALUES
(@quiz_id, UUID(), 'high-risk', 'High Copycat Risk Factor', 'result',
'[
  {"type": "heading", "content": "🔴 High Risk Alert"},
  {"type": "text", "content": "Hey {{first_name}}... Your answers indicated a Copycat Risk Factor of: HIGH. That means your business is currently vulnerable to intellectual property theft in multiple areas."},
  {"type": "text", "content": "But don''t panic - you took the quiz, which means you''re already ahead of 90% of entrepreneurs who have no idea they''re exposed. Knowing is the first step to taking powerful action to protect your business."},
  {"type": "button", "text": "Download Your Copycat Risk Factor Report", "url": "https://happyatlaw.com/report-high"},
  {"type": "heading", "content": "What Your HIGH Risk Score Means:"},
  {"type": "text", "content": "Your current business setup has significant gaps that make it easy for VAs and contractors to copy your proprietary materials, former team members to steal client lists and methods, competitors to replicate your processes without consequences, and AI tools to compromise your copyright protections."},
  {"type": "heading", "content": "IMMEDIATE ACTION STEPS (Do These Today):"},
  {"type": "text", "content": "Step 1: Audit who has access to your core materials right now\\nStep 2: Change passwords on any shared accounts with former team members\\nStep 3: Review your current contractor agreements for IP clauses"},
  {"type": "button", "text": "Protect My Business for $7 - Start Day 1 Now", "url": "https://happyatlaw.com/7-day-assessment"}
]',
1, 'copycat-high-risk', 'copycat-high-risk',
'{"minScore": 50, "maxScore": 999}');

-- Update quiz with scoring type
UPDATE quizzes SET scoring_type = 'sum' WHERE id = @quiz_id;

