-- HAL Business Foundation Score Quiz - Complete Seed Data
-- UPDATED: January 2026
-- Changes: Renamed quiz, 10 questions (from 23), new result tiers, $97 Challenge CTA
-- Run this AFTER the main database.sql to populate the quiz

-- Insert the quiz
INSERT INTO quizzes (uuid, slug, title, description, published, lead_capture_position, design) VALUES (
  UUID(),
  'business-foundation-score',
  'What''s Your Business Foundation Score?',
  'Discover in 2 minutes whether your business is built to operate like a valuable asset.',
  1,
  'on_landing',
  '{
    "primaryColor": "#FF6B8A",
    "secondaryColor": "#1E1B4B",
    "accentColor": "#4ADE80",
    "landingHeadline": "What''s Your Business Foundation Score?",
    "landingSubheadline": "Discover in 2 minutes whether your business is built to operate like a valuable asset—or still running on improvisation.",
    "formHeadline": "Enter Your Details to Begin!",
    "ctaText": "Get My Foundation Score →",
    "showRiskLevels": true,
    "benefitsHeadline": "What You''ll Discover in 2 Minutes:",
    "benefits": [
      "Your personalized Foundation Score with detailed breakdown",
      "Specific areas where your infrastructure needs attention",
      "Custom recommendations based on your business stage",
      "Clarity on your next steps to build with confidence"
    ],
    "bonusText": "Plus: Get your detailed Foundation Score Report delivered instantly to your email.",
    "showRiskSection": true,
    "riskHeadline": "What a Solid Foundation Means",
    "riskItems": [
      "Clarity when clients push back on scope or pricing",
      "Confidence that your team agreements protect your IP",
      "Peace of mind that your business operates like an asset",
      "Freedom to scale without fear of what might go wrong",
      "Professional credibility that commands respect"
    ],
    "riskCta": "Most successful entrepreneurs have infrastructure that matches their ambition.",
    "bottomCtaText": "Get My Foundation Score →"
  }'
);

SET @quiz_id = LAST_INSERT_ID();

-- Lead capture fields
INSERT INTO lead_fields (quiz_id, field_name, field_label, field_type, required, placeholder, order_index) VALUES
(@quiz_id, 'name', 'First Name', 'text', 1, 'First name *', 1),
(@quiz_id, 'email', 'Email', 'email', 1, 'Email *', 2);

-- ===========================================
-- 10 QUESTIONS (Trimmed from 23)
-- ===========================================

-- Q1: Business Type (Segmentation)
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index, settings) VALUES
(@quiz_id, UUID(), 'What best describes your business?', 'single', 1, '{"description": "This helps us personalize your recommendations"}');
SET @q1_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q1_id, UUID(), 'Online courses, digital products, or content', 2, 1),
(@q1_id, UUID(), 'Consulting, coaching, or speaking', 2, 2),
(@q1_id, UUID(), 'Freelance or professional services', 1, 3),
(@q1_id, UUID(), 'Product-based business (physical or digital)', 1, 4),
(@q1_id, UUID(), 'Agency or team-based services', 2, 5);

-- Q2: Current Agreement Status (Core Diagnostic)
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'How would you describe your current client agreements?', 'single', 2);
SET @q2_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q2_id, UUID(), 'I have professionally drafted contracts I use consistently', 0, 1),
(@q2_id, UUID(), 'I have contracts but they''re templates I found online', 4, 2),
(@q2_id, UUID(), 'I have informal agreements—emails, Slack messages, verbal', 6, 3),
(@q2_id, UUID(), 'I don''t usually use contracts', 8, 4);

-- Q3: Boundary Enforcement
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'When clients push back on scope, timelines, or pricing, what typically happens?', 'single', 3);
SET @q3_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q3_id, UUID(), 'I reference our agreement and hold the boundary', 0, 1),
(@q3_id, UUID(), 'I negotiate but usually give in to keep the peace', 4, 2),
(@q3_id, UUID(), 'I end up doing extra work without extra pay', 6, 3),
(@q3_id, UUID(), 'This happens so often I''ve accepted it as normal', 8, 4);

-- Q4: Team Agreements
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'Do you work with contractors, VAs, or team members who have access to your business systems?', 'single', 4);
SET @q4_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q4_id, UUID(), 'Yes, with signed agreements that include confidentiality and IP clauses', 0, 1),
(@q4_id, UUID(), 'Yes, with basic contracts but I''m not sure what''s covered', 4, 2),
(@q4_id, UUID(), 'Yes, but no formal agreements', 8, 3),
(@q4_id, UUID(), 'No, I work solo', 0, 4);

-- Q5: IP Protection Awareness
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'If a team member left tomorrow, how protected would your proprietary methods and client relationships be?', 'single', 5);
SET @q5_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q5_id, UUID(), 'Very protected—I have clear agreements preventing this', 0, 1),
(@q5_id, UUID(), 'Somewhat protected—I think my agreements cover this', 3, 2),
(@q5_id, UUID(), 'Not sure—I haven''t thought about it', 6, 3),
(@q5_id, UUID(), 'Not at all—nothing would stop them', 8, 4);

-- Q6: Content Creation/AI
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'How did you create your core offerings (courses, frameworks, methodologies)?', 'single', 6);
SET @q6_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q6_id, UUID(), '100% my original work, documented as such', 0, 1),
(@q6_id, UUID(), 'My work with some AI assistance for brainstorming/editing', 3, 2),
(@q6_id, UUID(), 'Significant AI-generated content that I refined', 6, 3),
(@q6_id, UUID(), 'Based on templates or frameworks I purchased/found', 4, 4),
(@q6_id, UUID(), 'I''m not sure of the original sources', 5, 5);

-- Q7: Agreement Maintenance
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'When was the last time you reviewed and updated your business agreements?', 'single', 7);
SET @q7_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q7_id, UUID(), 'Within the last 6 months', 0, 1),
(@q7_id, UUID(), 'Within the last year', 2, 2),
(@q7_id, UUID(), 'More than a year ago', 5, 3),
(@q7_id, UUID(), 'I''ve never done a formal review', 7, 4);

-- Q8: Dispute Confidence
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'If a client disputed a charge or demanded a refund, how confident are you in your position?', 'single', 8);
SET @q8_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q8_id, UUID(), 'Very confident—my agreements clearly define terms and remedies', 0, 1),
(@q8_id, UUID(), 'Somewhat confident—I think I''m covered', 3, 2),
(@q8_id, UUID(), 'Not very confident—I''d probably just give the refund', 6, 3),
(@q8_id, UUID(), 'Not confident at all—I have no clear policy', 8, 4);

-- Q9: Self-Assessment (Segmentation)
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index) VALUES
(@quiz_id, UUID(), 'How would you describe your approach to legal protection in your business?', 'single', 9);
SET @q9_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q9_id, UUID(), 'I''m proactive—I invest in legal infrastructure before problems arise', 0, 1),
(@q9_id, UUID(), 'I''m reactive—I address things when they become issues', 4, 2),
(@q9_id, UUID(), 'I''m avoidant—I know I should do more but haven''t prioritized it', 6, 3),
(@q9_id, UUID(), 'I''m overwhelmed—I don''t know where to start', 8, 4);

-- Q10: Emotional Driver (For follow-up personalization)
INSERT INTO questions (quiz_id, uuid, question_text, question_type, order_index, settings) VALUES
(@quiz_id, UUID(), 'What would having a solid business foundation mean for you?', 'single', 10, '{"description": "This helps us understand what matters most to you"}');
SET @q10_id = LAST_INSERT_ID();

INSERT INTO question_options (question_id, uuid, option_text, points, order_index) VALUES
(@q10_id, UUID(), 'Peace of mind—I''d stop worrying about what could go wrong', 0, 1),
(@q10_id, UUID(), 'Confidence—I''d feel like a "real" business owner', 0, 2),
(@q10_id, UUID(), 'Freedom to scale—I''d be ready to grow without fear', 0, 3),
(@q10_id, UUID(), 'Professional credibility—clients would take me more seriously', 0, 4);

-- ===========================================
-- RESULT PAGES (3 Tiers - New Names)
-- ===========================================

-- STRONG FOUNDATION (0-30 points)
INSERT INTO pages (quiz_id, uuid, slug, title, type, blocks, is_default, mailchimp_tag, kit_tag, settings) VALUES
(@quiz_id, UUID(), 'strong-foundation', 'Strong Foundation', 'result', 
'[
  {"type": "heading", "content": "🟢 Strong Foundation"},
  {"type": "text", "content": "Hey {{first_name}}, congratulations! Your Business Foundation Score shows you''ve built solid infrastructure for your business."},
  {"type": "text", "content": "You''re in an elite category—you''ve invested in protecting what you''ve built, and it shows. Your agreements, boundaries, and systems reflect a business that operates like a valuable asset."},
  {"type": "text", "content": "Check out the detailed breakdown I prepared for you. I emailed it to: {{email}}."},
  {"type": "button", "text": "Download Your Foundation Score Report", "url": "https://happyatlaw.com/report-strong"},
  {"type": "heading", "content": "What Your STRONG Foundation Score Means:"},
  {"type": "text", "content": "You''ve established the legal infrastructure that most entrepreneurs overlook. But maintaining and optimizing that foundation is an ongoing process—especially as your business grows and evolves."},
  {"type": "heading", "content": "YOUR NEXT LEVEL:"},
  {"type": "text", "content": "Strong foundation businesses face sophisticated challenges: advanced competitor intelligence, team retention strategies, evolving AI regulations, and scaling complexity. The Contract Assessment Challenge can help you stress-test your current infrastructure and identify optimization opportunities."},
  {"type": "button", "text": "Stress-Test My Foundation - $97", "url": "https://happyatlawnetwork.com/contract-assessment-challenge"},
  {"type": "text", "content": "Or explore the Happy At Law Network for ongoing support and community with other serious business owners who prioritize their infrastructure."},
  {"type": "button", "text": "Explore the HAL Network", "url": "https://happyatlawnetwork.com"}
]',
0, 'foundation-strong', 'foundation-strong',
'{"minScore": 0, "maxScore": 30}');

-- GROWING FOUNDATION (31-59 points)
INSERT INTO pages (quiz_id, uuid, slug, title, type, blocks, is_default, mailchimp_tag, kit_tag, settings) VALUES
(@quiz_id, UUID(), 'growing-foundation', 'Growing Foundation', 'result',
'[
  {"type": "heading", "content": "🟡 Growing Foundation"},
  {"type": "text", "content": "Hey {{first_name}}, your Business Foundation Score shows you''re making good progress—with some strategic gaps to address."},
  {"type": "text", "content": "You have some infrastructure in place, which puts you ahead of most entrepreneurs. But there are specific areas where strengthening your foundation now will prevent bigger problems later."},
  {"type": "text", "content": "Think of it like having a house with a solid frame but a few windows that need weatherproofing—manageable now, but they''ll cause problems if left unaddressed."},
  {"type": "button", "text": "Download Your Foundation Score Report", "url": "https://happyatlaw.com/report-growing"},
  {"type": "heading", "content": "What Your GROWING Foundation Score Means:"},
  {"type": "text", "content": "Your business has protection in some areas but gaps in others. This is common for entrepreneurs who''ve been focused on growth—the business has evolved faster than the infrastructure supporting it."},
  {"type": "heading", "content": "YOUR STRATEGIC NEXT STEP:"},
  {"type": "text", "content": "The Contract Assessment Challenge is designed for exactly this stage. In 7 days, you''ll audit your current agreements, identify the specific gaps in your foundation, and create a prioritized action plan."},
  {"type": "button", "text": "Start the Contract Assessment Challenge - $97", "url": "https://happyatlawnetwork.com/contract-assessment-challenge"}
]',
0, 'foundation-growing', 'foundation-growing',
'{"minScore": 31, "maxScore": 59}');

-- BUILDING FOUNDATION (60+ points)
INSERT INTO pages (quiz_id, uuid, slug, title, type, blocks, is_default, mailchimp_tag, kit_tag, settings) VALUES
(@quiz_id, UUID(), 'building-foundation', 'Building Foundation', 'result',
'[
  {"type": "heading", "content": "🔷 Building Foundation"},
  {"type": "text", "content": "Hey {{first_name}}, your Business Foundation Score shows this is the perfect time to establish the infrastructure your business deserves."},
  {"type": "text", "content": "Here''s the truth: You''ve been so focused on serving clients and creating amazing work that the \"boring business stuff\" took a back seat. This is incredibly common among talented entrepreneurs."},
  {"type": "text", "content": "The good news? You now have clarity on exactly what needs attention. And you''re in the perfect position to build a foundation that matches the value of what you''ve created."},
  {"type": "button", "text": "Download Your Foundation Score Report", "url": "https://happyatlaw.com/report-building"},
  {"type": "heading", "content": "What Your BUILDING Foundation Score Means:"},
  {"type": "text", "content": "Your business has grown faster than your infrastructure. Without attention, this creates vulnerability—but with the right action, you can transform this into a business that operates like the valuable asset it truly is."},
  {"type": "heading", "content": "YOUR TRANSFORMATION STARTS HERE:"},
  {"type": "text", "content": "The Contract Assessment Challenge gives you a clear, guided path forward. In 7 days, you''ll understand exactly what your business needs and have a prioritized plan to build it—for just $97."},
  {"type": "button", "text": "Start Building My Foundation - $97", "url": "https://happyatlawnetwork.com/contract-assessment-challenge"}
]',
1, 'foundation-building', 'foundation-building',
'{"minScore": 60, "maxScore": 999}');

-- Update quiz with scoring type
UPDATE quizzes SET scoring_type = 'sum' WHERE id = @quiz_id;

-- ===========================================
-- NOTES FOR IMPLEMENTATION
-- ===========================================
-- 
-- Scoring Thresholds:
-- - Strong Foundation: 0-30 points
-- - Growing Foundation: 31-59 points  
-- - Building Foundation: 60+ points
--
-- Max possible score: ~65 points
-- (Lower than old quiz since we reduced from 23 to 10 questions)
--
-- Email Tags:
-- - foundation-strong
-- - foundation-growing
-- - foundation-building
--
-- All CTAs point to $97 Contract Assessment Challenge
-- (replaces old $7 Emergency Assessment)
--
