-- =============================================
-- ADD CUSTOM DOMAIN SUPPORT TO QUIZZES
-- Run this in phpMyAdmin
-- =============================================

-- Add custom_domain column to quizzes table
ALTER TABLE quizzes 
ADD COLUMN custom_domain VARCHAR(255) DEFAULT NULL AFTER slug,
ADD COLUMN is_default TINYINT(1) DEFAULT 0 AFTER custom_domain;

-- Add index for fast domain lookups
CREATE INDEX idx_custom_domain ON quizzes(custom_domain);

-- =============================================
-- LINK YOUR QUIZZES TO DOMAINS
-- Update these with your actual quiz IDs
-- =============================================

-- Foundation Score Quiz
UPDATE quizzes 
SET custom_domain = 'myfoundationscore.com' 
WHERE slug = 'foundation-score';

-- Copycat Risk Factor Quiz  
UPDATE quizzes 
SET custom_domain = 'copycatriskfactor.com' 
WHERE slug = 'copycat-risk';

-- Set Foundation Score as default (optional - for app.happyatlaw.com direct visits)
UPDATE quizzes 
SET is_default = 1 
WHERE slug = 'foundation-score';
