# QUIZ FUNNEL DEPLOYMENT GUIDE
## One Platform, Multiple Quiz Domains

---

## WHAT YOU'RE SETTING UP

```
app.happyatlaw.com (hidden - the engine)
       │
       ├── myfoundationscore.com  → Foundation Score Quiz
       └── copycatriskfactor.com  → Copycat Risk Quiz
```

Visitors go to the custom domain. They never see app.happyatlaw.com.

---

## STEP-BY-STEP CHECKLIST

### STEP 1: Buy Domain
- [ ] Go to your domain registrar
- [ ] Buy `myfoundationscore.com` (about $12/year)
- [ ] You already own `copycatriskfactor.com`

---

### STEP 2: Create Subdomain in cPanel

1. Log into cPanel
2. Find **"Subdomains"** (under Domains section)
3. Create subdomain:
   - Subdomain: `app`
   - Domain: `happyatlaw.com`
   - Document Root: `/home/[username]/app.happyatlaw.com`
4. Click **Create**

**Write down the folder path:** `/home/_______/app.happyatlaw.com`

---

### STEP 3: Point Quiz Domains to cPanel

**For EACH quiz domain (myfoundationscore.com AND copycatriskfactor.com):**

**Option A: If domains are at SAME registrar as hosting:**
1. In cPanel, find **"Addon Domains"** or **"Domains"**
2. Add domain: `myfoundationscore.com`
3. Document Root: `/home/[username]/app.happyatlaw.com/public_html`
4. Repeat for `copycatriskfactor.com`

**Option B: If domains are at DIFFERENT registrar:**
1. Log into domain registrar (where you bought the domain)
2. Find DNS settings
3. Add A record:
   - Host: `@`
   - Points to: `[Your hosting IP address]`
4. Add another A record:
   - Host: `www`
   - Points to: `[Your hosting IP address]`
5. Then do Option A steps in cPanel

**To find your hosting IP:** cPanel → right side → "Shared IP Address"

---

### STEP 4: Upload Quiz Files

1. In cPanel, open **File Manager**
2. Navigate to `/home/[username]/app.happyatlaw.com`
3. Upload all quiz platform files here
4. File structure should look like:
```
app.happyatlaw.com/
├── server.js
├── package.json
├── .env
├── middleware/
│   ├── domainDetect.js    ← NEW FILE
│   └── ...
├── routes/
├── public_html/
└── ...
```

---

### STEP 5: Create Database

1. In cPanel, go to **MySQL Databases**
2. Create database: `quizfunnel` (will become `username_quizfunnel`)
3. Create user with password
4. Add user to database with ALL PRIVILEGES
5. Go to **phpMyAdmin**
6. Select your database
7. Click **Import**
8. Import `database.sql` first
9. Import `add-custom-domains.sql` second

---

### STEP 6: Configure .env File

1. In File Manager, navigate to app folder
2. Create new file named `.env`
3. Add this content (fill in YOUR values):

```
DB_HOST=localhost
DB_USER=username_quizuser
DB_PASSWORD=your_password_here
DB_NAME=username_quizfunnel

APP_URL=https://app.happyatlaw.com
PORT=3000

JWT_SECRET=generate-random-64-characters
```

---

### STEP 7: Install & Start

**Option A: If you have SSH access:**
```bash
cd ~/app.happyatlaw.com
npm install
```

**Option B: If using cPanel Node.js App:**
1. Go to **Setup Node.js App**
2. Create Application:
   - Node version: 18+
   - App root: `app.happyatlaw.com`
   - App URL: `app.happyatlaw.com`
   - Startup file: `server.js`
3. Click Create
4. Click **Run NPM Install**
5. Click **Start App**

---

### STEP 8: Link Quizzes to Domains

In phpMyAdmin, run:

```sql
-- Link Foundation Score to its domain
UPDATE quizzes 
SET custom_domain = 'myfoundationscore.com' 
WHERE slug = 'foundation-score';

-- Link Copycat Risk to its domain
UPDATE quizzes 
SET custom_domain = 'copycatriskfactor.com' 
WHERE slug = 'copycat-risk';
```

---

### STEP 9: Test

1. Visit `https://myfoundationscore.com`
   - Should show Foundation Score quiz directly
   
2. Visit `https://copycatriskfactor.com`
   - Should show Copycat Risk quiz directly

3. Visit `https://app.happyatlaw.com/admin`
   - Should show admin dashboard
   - Can see ALL leads from BOTH quizzes here

---

## TROUBLESHOOTING

**"Site not found" or DNS error:**
- DNS can take up to 24 hours (usually 15 min)
- Check A records are pointing to correct IP

**"502 Bad Gateway":**
- Node app not running
- Go to cPanel → Setup Node.js App → Restart

**Quiz not loading on custom domain:**
- Check database: is `custom_domain` set correctly?
- Check domain spelling matches exactly

**SSL certificate error:**
- In cPanel → SSL/TLS → manage SSL
- Or use AutoSSL in cPanel

---

## FILES THAT WERE UPDATED

1. `middleware/domainDetect.js` - NEW FILE (detects domain, loads quiz)
2. `routes/quiz.js` - Added `/api/quiz/by-domain` endpoint
3. `server.js` - Added domain detection middleware
4. `database/add-custom-domains.sql` - NEW FILE (adds domain column)

---

## ADDING MORE QUIZZES LATER

1. Create quiz in admin dashboard
2. Buy/setup new domain
3. Point domain to same server (Step 3)
4. Run SQL to link quiz to domain:
```sql
UPDATE quizzes SET custom_domain = 'newquiz.com' WHERE slug = 'new-quiz-slug';
```
5. Done!
